"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const moment_1 = tslib_1.__importDefault(require("moment"));
const react_1 = tslib_1.__importDefault(require("react"));
const timefilter_1 = require("ui/timefilter");
class SyncChartGroup extends react_1.default.Component {
    constructor() {
        super(...arguments);
        this.state = { hoverX: null };
        this.onHover = hoverX => this.setState({ hoverX });
        this.onMouseLeave = () => this.setState({ hoverX: null });
        this.onSelectionEnd = range => {
            this.setState({ hoverX: null });
            timefilter_1.timefilter.setTime({
                from: moment_1.default(range.start).toISOString(),
                to: moment_1.default(range.end).toISOString(),
                mode: 'absolute'
            });
        };
    }
    render() {
        return this.props.render({
            onHover: this.onHover,
            onMouseLeave: this.onMouseLeave,
            onSelectionEnd: this.onSelectionEnd,
            hoverX: this.state.hoverX
        });
    }
}
exports.SyncChartGroup = SyncChartGroup;
