"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importStar(require("react"));
const EmptyMessage_1 = require("../../shared/EmptyMessage");
const LibraryStackFrames_1 = require("./LibraryStackFrames");
const Stackframe_1 = require("./Stackframe");
function Stacktrace({ stackframes = [], codeLanguage }) {
    if (lodash_1.isEmpty(stackframes)) {
        return (react_1.default.createElement(EmptyMessage_1.EmptyMessage, { heading: i18n_1.i18n.translate('xpack.apm.stacktraceTab.noStacktraceAvailableLabel', {
                defaultMessage: 'No stacktrace available.'
            }), hideSubheading: true }));
    }
    const groups = getGroupedStackframes(stackframes);
    return (react_1.default.createElement(react_1.Fragment, null,
        groups.map((group, i) => {
            // library frame
            if (group.isLibraryFrame) {
                const hasMultipleStackframes = group.stackframes.length > 1;
                const hasLeadingSpacer = hasMultipleStackframes && i !== 0;
                const hasTrailingSpacer = hasMultipleStackframes && i !== groups.length - 1;
                return (react_1.default.createElement(react_1.Fragment, { key: i },
                    hasLeadingSpacer && react_1.default.createElement(eui_1.EuiSpacer, { size: "m" }),
                    react_1.default.createElement(LibraryStackFrames_1.LibraryStackFrames, { initialVisiblity: !hasMultipleStackframes, stackframes: group.stackframes, codeLanguage: codeLanguage }),
                    hasTrailingSpacer && react_1.default.createElement(eui_1.EuiSpacer, { size: "m" })));
            }
            // non-library frame
            return group.stackframes.map((stackframe, idx) => (react_1.default.createElement(Stackframe_1.Stackframe, { key: `${i}-${idx}`, codeLanguage: codeLanguage, stackframe: stackframe })));
        }),
        react_1.default.createElement(eui_1.EuiSpacer, { size: "m" })));
}
exports.Stacktrace = Stacktrace;
function getGroupedStackframes(stackframes) {
    return stackframes.reduce((acc, stackframe) => {
        const prevGroup = lodash_1.last(acc);
        const shouldAppend = prevGroup &&
            prevGroup.isLibraryFrame === stackframe.library_frame &&
            !prevGroup.excludeFromGrouping &&
            !stackframe.exclude_from_grouping;
        // append to group
        if (shouldAppend) {
            prevGroup.stackframes.push(stackframe);
            return acc;
        }
        // create new group
        acc.push({
            isLibraryFrame: Boolean(stackframe.library_frame),
            excludeFromGrouping: Boolean(stackframe.exclude_from_grouping),
            stackframes: [stackframe]
        });
        return acc;
    }, []);
}
exports.getGroupedStackframes = getGroupedStackframes;
