"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const variables_1 = require("../../../style/variables");
// @ts-ignore
const Icons_1 = require("../Icons");
const PropertiesTable_1 = require("../PropertiesTable");
const VariablesContainer = styled_components_1.default.div `
  background: ${variables_1.colors.white};
  border-top: 1px solid ${variables_1.colors.gray4};
  border-radius: 0 0 ${variables_1.borderRadius} ${variables_1.borderRadius};
  padding: ${variables_1.px(variables_1.units.half)} ${variables_1.px(variables_1.unit)};
  font-family: ${variables_1.fontFamily};
`;
const VariablesToggle = styled_components_1.default.a `
  display: block;
  cursor: pointer;
  user-select: none;
`;
const VariablesTableContainer = styled_components_1.default.div `
  padding: ${variables_1.px(variables_1.units.plus)} ${variables_1.px(variables_1.unit)} 0;
`;
class Variables extends react_1.default.Component {
    constructor() {
        super(...arguments);
        this.state = {
            isVisible: false
        };
        this.onClick = () => {
            this.setState(() => ({ isVisible: !this.state.isVisible }));
        };
    }
    render() {
        if (!this.props.vars) {
            return null;
        }
        return (react_1.default.createElement(VariablesContainer, null,
            react_1.default.createElement(VariablesToggle, { onClick: this.onClick },
                react_1.default.createElement(Icons_1.Ellipsis, { horizontal: this.state.isVisible, style: { marginRight: variables_1.units.half } }),
                ' ',
                i18n_1.i18n.translate('xpack.apm.stacktraceTab.localVariablesToogleButtonLabel', { defaultMessage: 'Local variables' })),
            this.state.isVisible && (react_1.default.createElement(VariablesTableContainer, null,
                react_1.default.createElement(PropertiesTable_1.PropertiesTable, { propData: this.props.vars, propKey: 'custom' })))));
    }
}
exports.Variables = Variables;
