"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const variables_1 = require("../../../style/variables");
const FileDetails = styled_components_1.default.div `
  color: ${variables_1.colors.gray3};
  padding: ${variables_1.px(variables_1.units.half)};
  font-family: ${variables_1.fontFamilyCode};
`;
const LibraryFrameFileDetail = styled_components_1.default.span `
  color: ${variables_1.colors.gray2};
`;
const AppFrameFileDetail = styled_components_1.default.span `
  font-weight: bold;
  color: ${variables_1.colors.black};
`;
const FrameHeading = ({ stackframe, isLibraryFrame }) => {
    const FileDetail = isLibraryFrame
        ? LibraryFrameFileDetail
        : AppFrameFileDetail;
    const lineNumber = lodash_1.get(stackframe, 'line.number');
    return (react_1.default.createElement(FileDetails, null,
        react_1.default.createElement(FileDetail, null, stackframe.filename),
        " in",
        ' ',
        react_1.default.createElement(FileDetail, null, stackframe.function),
        lineNumber > 0 && (react_1.default.createElement(react_1.Fragment, null,
            ' at ',
            react_1.default.createElement(FileDetail, null,
                "line ",
                stackframe.line.number)))));
};
exports.FrameHeading = FrameHeading;
