"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
// TODO add dependency for @types/react-syntax-highlighter
// @ts-ignore
const javascript_1 = tslib_1.__importDefault(require("react-syntax-highlighter/dist/languages/javascript"));
// @ts-ignore
const python_1 = tslib_1.__importDefault(require("react-syntax-highlighter/dist/languages/python"));
// @ts-ignore
const ruby_1 = tslib_1.__importDefault(require("react-syntax-highlighter/dist/languages/ruby"));
// @ts-ignore
const light_1 = tslib_1.__importDefault(require("react-syntax-highlighter/dist/light"));
// @ts-ignore
const light_2 = require("react-syntax-highlighter/dist/light");
// @ts-ignore
const styles_1 = require("react-syntax-highlighter/dist/styles");
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const variables_1 = require("../../../style/variables");
light_2.registerLanguage('javascript', javascript_1.default);
light_2.registerLanguage('python', python_1.default);
light_2.registerLanguage('ruby', ruby_1.default);
const ContextContainer = styled_components_1.default.div `
  position: relative;
  border-radius: 0 0 ${variables_1.borderRadius} ${variables_1.borderRadius};
`;
const LINE_HEIGHT = variables_1.units.eighth * 9;
const LineHighlight = styled_components_1.default.div `
  position: absolute;
  width: 100%;
  height: ${variables_1.px(variables_1.units.eighth * 9)};
  top: ${props => variables_1.px(props.lineNumber * LINE_HEIGHT)};
  pointer-events: none;
  background-color: ${variables_1.colors.yellow};
`;
const LineNumberContainer = styled_components_1.default.div `
  position: absolute;
  top: 0;
  left: 0;
  border-radius: 0 0 0 ${variables_1.borderRadius};
  background: ${props => (props.isLibraryFrame ? variables_1.colors.white : variables_1.colors.gray5)};
`;
const LineNumber = styled_components_1.default.div `
  position: relative;
  min-width: ${variables_1.px(variables_1.units.eighth * 21)};
  padding-left: ${variables_1.px(variables_1.units.half)};
  padding-right: ${variables_1.px(variables_1.units.quarter)};
  color: ${variables_1.colors.gray3};
  line-height: ${variables_1.px(variables_1.unit + variables_1.units.eighth)};
  text-align: right;
  border-right: 1px solid ${variables_1.colors.gray4};
  background-color: ${props => (props.highlight ? variables_1.colors.yellow : null)};

  &:last-of-type {
    border-radius: 0 0 0 ${variables_1.borderRadius};
  }
`;
const LineContainer = styled_components_1.default.div `
  overflow: auto;
  margin: 0 0 0 ${variables_1.px(variables_1.units.eighth * 21)};
  padding: 0;
  background-color: ${variables_1.colors.white};

  &:last-of-type {
    border-radius: 0 0 ${variables_1.borderRadius} 0;
  }
`;
const Line = styled_components_1.default.pre `
  // Override all styles
  margin: 0;
  color: inherit;
  background: inherit;
  border: 0;
  border-radius: 0;
  overflow: initial;
  padding: 0 ${variables_1.px(LINE_HEIGHT)};
  line-height: ${variables_1.px(LINE_HEIGHT)};
`;
const Code = styled_components_1.default.code `
  position: relative;
  padding: 0;
  margin: 0;
  white-space: pre;
  z-index: 2;
`;
function getStackframeLines(stackframe) {
    const line = stackframe.line.context;
    const preLines = lodash_1.get(stackframe, 'context.pre', []);
    const postLines = lodash_1.get(stackframe, 'context.post', []);
    return [...preLines, line, ...postLines];
}
function getStartLineNumber(stackframe) {
    const preLines = lodash_1.size(lodash_1.get(stackframe, 'context.pre', []));
    return stackframe.line.number - preLines;
}
function Context({ stackframe, codeLanguage, isLibraryFrame }) {
    const lines = getStackframeLines(stackframe);
    const startLineNumber = getStartLineNumber(stackframe);
    const highlightedLineIndex = lodash_1.size(lodash_1.get(stackframe, 'context.pre', []));
    const language = codeLanguage || 'javascript'; // TODO: Add support for more languages
    return (react_1.default.createElement(ContextContainer, null,
        react_1.default.createElement(LineHighlight, { lineNumber: highlightedLineIndex }),
        react_1.default.createElement(LineNumberContainer, { isLibraryFrame: isLibraryFrame }, lines.map((line, i) => (react_1.default.createElement(LineNumber, { key: line + i, highlight: highlightedLineIndex === i },
            i + startLineNumber,
            ".")))),
        react_1.default.createElement(LineContainer, null, lines.map((line, i) => (react_1.default.createElement(light_1.default, { key: line + i, language: language, style: styles_1.xcode, PreTag: Line, CodeTag: Code, customStyle: { padding: null, overflowX: null } }, line || '\n'))))));
}
exports.Context = Context;
