"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importDefault(require("react"));
const url_helpers_1 = require("./url_helpers");
exports.MLJobLink = ({ serviceName, transactionType, location, children }) => {
    const pathname = '/app/ml';
    const hash = '/timeseriesexplorer';
    const maybeTransactionType = transactionType ? transactionType + '-' : '';
    const jobId = `${serviceName}-${maybeTransactionType}high_mean_response_time`;
    const query = {
        _g: { ml: { jobIds: [jobId] } }
    };
    const href = url_helpers_1.getKibanaHref({
        location,
        pathname,
        hash,
        query
    });
    return react_1.default.createElement(eui_1.EuiLink, { children: children, href: href });
};
