"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const constants_1 = require("x-pack/plugins/apm/common/constants");
const DiscoverLink_1 = require("./DiscoverLink");
function getDiscoverQuery(transaction) {
    const transactionId = transaction.transaction.id;
    const traceId = transaction.version === 'v2' ? transaction.trace.id : undefined;
    let query = `${constants_1.PROCESSOR_EVENT}:"transaction" AND ${constants_1.TRANSACTION_ID}:"${transactionId}"`;
    if (traceId) {
        query += ` AND ${constants_1.TRACE_ID}:"${traceId}"`;
    }
    return {
        _a: {
            interval: 'auto',
            query: {
                language: 'lucene',
                query
            }
        }
    };
}
exports.getDiscoverQuery = getDiscoverQuery;
exports.DiscoverTransactionLink = ({ transaction, children }) => {
    return (react_1.default.createElement(DiscoverLink_1.DiscoverLink, { query: getDiscoverQuery(transaction), children: children }));
};
