"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const KibanaLink_1 = require("../KibanaLink");
const QueryWithIndexPattern_1 = require("./QueryWithIndexPattern");
function DiscoverLink({ query, ...rest }) {
    return (react_1.default.createElement(QueryWithIndexPattern_1.QueryWithIndexPattern, { query: query }, queryWithIndexPattern => (react_1.default.createElement(KibanaLink_1.KibanaLink, Object.assign({ pathname: '/app/kibana', hash: '/discover', query: queryWithIndexPattern }, rest)))));
}
exports.DiscoverLink = DiscoverLink;
