"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const react_router_dom_1 = require("react-router-dom");
const TransactionCharts_1 = require("x-pack/plugins/apm/public/components/shared/charts/TransactionCharts");
const url_helpers_1 = require("x-pack/plugins/apm/public/components/shared/Links/url_helpers");
const transactionList_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/transactionList");
const transactionOverviewCharts_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/transactionOverviewCharts");
const List_1 = require("./List");
class TransactionOverviewView extends react_1.default.Component {
    constructor() {
        super(...arguments);
        this.handleTypeChange = (event) => {
            const { urlParams, history, location } = this.props;
            const type = url_helpers_1.legacyEncodeURIComponent(event.target.value);
            history.push({
                ...location,
                pathname: `/${urlParams.serviceName}/transactions/${type}`
            });
        };
    }
    render() {
        const { urlParams, serviceTransactionTypes, location } = this.props;
        const { serviceName, transactionType } = urlParams;
        // filtering by type is currently required
        if (!serviceName || !transactionType) {
            return null;
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            serviceTransactionTypes.length > 1 ? (react_1.default.createElement(eui_1.EuiFormRow, { label: i18n_1.i18n.translate('xpack.apm.transactionsTable.filterByTypeLabel', {
                    defaultMessage: 'Filter by type'
                }) },
                react_1.default.createElement(eui_1.EuiSelect, { options: serviceTransactionTypes.map(type => ({
                        text: `${type}`,
                        value: type
                    })), value: transactionType, onChange: this.handleTypeChange }))) : null,
            react_1.default.createElement(transactionOverviewCharts_1.TransactionOverviewChartsRequest, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(TransactionCharts_1.TransactionCharts, { charts: data, location: location, urlParams: urlParams })) }),
            react_1.default.createElement(eui_1.EuiSpacer, { size: "l" }),
            react_1.default.createElement(transactionList_1.TransactionListRequest, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(List_1.TransactionList, { items: data, serviceName: serviceName })) })));
    }
}
exports.TransactionOverviewView = TransactionOverviewView;
exports.TransactionOverview = react_router_dom_1.withRouter(TransactionOverviewView);
