"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const TransactionActionMenu_1 = require("../../../shared/TransactionActionMenu/TransactionActionMenu");
const TransactionLink_1 = require("../../../shared/TransactionLink");
const StickyTransactionProperties_1 = require("./StickyTransactionProperties");
const TransactionPropertiesTable_1 = require("./TransactionPropertiesTable");
function MaybeViewTraceLink({ transaction, waterfall }) {
    const viewFullTraceButtonLabel = i18n_1.i18n.translate('xpack.apm.transactionDetails.viewFullTraceButtonLabel', {
        defaultMessage: 'View full trace'
    });
    // the traceroot cannot be found, so we cannot link to it
    if (!waterfall.traceRoot) {
        return (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(eui_1.EuiToolTip, { content: i18n_1.i18n.translate('xpack.apm.transactionDetails.noTraceParentButtonTooltip', {
                    defaultMessage: 'The trace parent cannot be found'
                }) },
                react_1.default.createElement(eui_1.EuiButton, { iconType: "apmTrace", disabled: true }, viewFullTraceButtonLabel))));
    }
    const isRoot = transaction.transaction.id === waterfall.traceRoot.transaction.id;
    // the user is already viewing the full trace, so don't link to it
    if (isRoot) {
        return (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(eui_1.EuiToolTip, { content: i18n_1.i18n.translate('xpack.apm.transactionDetails.viewingFullTraceButtonTooltip', {
                    defaultMessage: 'Currently viewing the full trace'
                }) },
                react_1.default.createElement(eui_1.EuiButton, { iconType: "apmTrace", disabled: true }, viewFullTraceButtonLabel))));
        // the user is viewing a zoomed in version of the trace. Link to the full trace
    }
    else {
        return (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(TransactionLink_1.TransactionLink, { transaction: waterfall.traceRoot },
                react_1.default.createElement(eui_1.EuiButton, { iconType: "apmTrace" }, viewFullTraceButtonLabel))));
    }
}
exports.Transaction = ({ transaction, urlParams, location, waterfall }) => {
    return (react_1.default.createElement(eui_1.EuiPanel, { paddingSize: "m" },
        react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceBetween" },
            react_1.default.createElement(eui_1.EuiFlexItem, null,
                react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
                    react_1.default.createElement("h5", null, i18n_1.i18n.translate('xpack.apm.transactionDetails.transactionSampleTitle', {
                        defaultMessage: 'Transaction sample'
                    })))),
            react_1.default.createElement(eui_1.EuiFlexItem, null,
                react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "flexEnd" },
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(TransactionActionMenu_1.TransactionActionMenu, { transaction: transaction, location: location })),
                    react_1.default.createElement(MaybeViewTraceLink, { transaction: transaction, waterfall: waterfall })))),
        react_1.default.createElement(eui_1.EuiSpacer, null),
        react_1.default.createElement(StickyTransactionProperties_1.StickyTransactionProperties, { transaction: transaction, totalDuration: waterfall.traceRootDuration }),
        react_1.default.createElement(eui_1.EuiSpacer, null),
        react_1.default.createElement(TransactionPropertiesTable_1.TransactionPropertiesTable, { transaction: transaction, location: location, urlParams: urlParams, waterfall: waterfall })));
};
