"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
// @ts-ignore
const react_sticky_1 = require("react-sticky");
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const url_helpers_1 = require("x-pack/plugins/apm/public/components/shared/Links/url_helpers");
// @ts-ignore
const Timeline_1 = tslib_1.__importDefault(require("../../../../../shared/charts/Timeline"));
const SpanFlyout_1 = require("./SpanFlyout");
const TransactionFlyout_1 = require("./TransactionFlyout");
const WaterfallItem_1 = require("./WaterfallItem");
const Container = styled_components_1.default.div `
  transition: 0.1s padding ease;
  position: relative;
  overflow: hidden;
`;
const TIMELINE_MARGINS = {
    top: 40,
    left: 50,
    right: 50,
    bottom: 0
};
class Waterfall extends react_1.Component {
    constructor() {
        super(...arguments);
        this.onOpenFlyout = (item) => {
            this.setQueryParams({
                flyoutDetailTab: undefined,
                waterfallItemId: String(item.id)
            });
        };
        this.onCloseFlyout = () => {
            this.setQueryParams({
                flyoutDetailTab: undefined,
                waterfallItemId: undefined
            });
        };
        this.getWaterfallItem = (item) => {
            const { serviceColors, waterfall, urlParams } = this.props;
            return (react_1.default.createElement(WaterfallItem_1.WaterfallItem, { key: item.id, timelineMargins: TIMELINE_MARGINS, color: serviceColors[item.serviceName], item: item, totalDuration: waterfall.duration, isSelected: item.id === urlParams.waterfallItemId, onClick: () => this.onOpenFlyout(item) }));
        };
        this.getFlyOut = () => {
            const { waterfall, location, urlParams } = this.props;
            const currentItem = urlParams.waterfallItemId &&
                waterfall.itemsById[urlParams.waterfallItemId];
            if (!currentItem) {
                return null;
            }
            switch (currentItem.docType) {
                case 'span':
                    const parentTransaction = waterfall.getTransactionById(currentItem.parentId);
                    return (react_1.default.createElement(SpanFlyout_1.SpanFlyout, { totalDuration: waterfall.duration, span: currentItem.span, parentTransaction: parentTransaction, onClose: this.onCloseFlyout }));
                case 'transaction':
                    return (react_1.default.createElement(TransactionFlyout_1.TransactionFlyout, { transaction: currentItem.transaction, onClose: this.onCloseFlyout, location: location, urlParams: urlParams, waterfall: waterfall }));
                default:
                    return null;
            }
        };
    }
    render() {
        const { waterfall } = this.props;
        const itemContainerHeight = 58; // TODO: This is a nasty way to calculate the height of the svg element. A better approach should be found
        const waterfallHeight = itemContainerHeight * waterfall.items.length;
        return (react_1.default.createElement(Container, null,
            react_1.default.createElement(react_sticky_1.StickyContainer, null,
                react_1.default.createElement(Timeline_1.default, { agentMarks: this.props.agentMarks, duration: waterfall.duration, traceRootDuration: waterfall.traceRootDuration, height: waterfallHeight, margins: TIMELINE_MARGINS }),
                react_1.default.createElement("div", { style: {
                        paddingTop: TIMELINE_MARGINS.top
                    } }, waterfall.items.map(this.getWaterfallItem))),
            this.getFlyOut()));
    }
    setQueryParams(params) {
        const { location } = this.props;
        url_helpers_1.history.replace({
            ...location,
            search: url_helpers_1.fromQuery({
                ...url_helpers_1.toQuery(location.search),
                ...params
            })
        });
    }
}
exports.Waterfall = Waterfall;
