"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const TransactionActionMenu_1 = require("x-pack/plugins/apm/public/components/shared/TransactionActionMenu/TransactionActionMenu");
const apm_get_started_1 = require("x-pack/plugins/apm/public/utils/documentation/apm-get-started");
const StickyTransactionProperties_1 = require("../../../StickyTransactionProperties");
const TransactionPropertiesTableForFlyout_1 = require("../../../TransactionPropertiesTableForFlyout");
const FlyoutTopLevelProperties_1 = require("../FlyoutTopLevelProperties");
const ResponsiveFlyout = styled_components_1.default(eui_1.EuiFlyout) `
  width: 100%;

  @media (min-width: 800px) {
    width: 90%;
  }

  @media (min-width: 1000px) {
    width: 70%;
  }

  @media (min-width: 1400px) {
    width: 50%;
  }

  @media (min-width: 2000px) {
    width: 35%;
  }
`;
function DroppedSpansWarning({ transactionDoc }) {
    const dropped = lodash_1.get(transactionDoc, 'transaction.span_count.dropped.total', 0);
    if (dropped === 0) {
        return null;
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(eui_1.EuiCallOut, { size: "s" },
            i18n_1.i18n.translate('xpack.apm.transactionDetails.transFlyout.callout.agentDroppedSpansMessage', {
                defaultMessage: 'The APM agent that reported this transaction dropped {dropped} spans or more based on its configuration.',
                values: { dropped }
            }),
            ' ',
            react_1.default.createElement(eui_1.EuiLink, { href: apm_get_started_1.DROPPED_SPANS_DOCS, target: "_blank" }, i18n_1.i18n.translate('xpack.apm.transactionDetails.transFlyout.callout.learnMoreAboutDroppedSpansLinkText', {
                defaultMessage: 'Learn more about dropped spans.'
            }))),
        react_1.default.createElement(eui_1.EuiHorizontalRule, null)));
}
function TransactionFlyout({ transaction: transactionDoc, onClose, location, urlParams, waterfall }) {
    if (!transactionDoc) {
        return null;
    }
    return (react_1.default.createElement(eui_1.EuiPortal, null,
        react_1.default.createElement(ResponsiveFlyout, { onClose: onClose, ownFocus: true, maxWidth: false },
            react_1.default.createElement(eui_1.EuiFlyoutHeader, { hasBorder: true },
                react_1.default.createElement(eui_1.EuiFlexGroup, null,
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(eui_1.EuiTitle, null,
                            react_1.default.createElement("h4", null, i18n_1.i18n.translate('xpack.apm.transactionDetails.transFlyout.transactionDetailsTitle', {
                                defaultMessage: 'Transaction details'
                            })))),
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(TransactionActionMenu_1.TransactionActionMenu, { transaction: transactionDoc, location: location })))),
            react_1.default.createElement(eui_1.EuiFlyoutBody, null,
                react_1.default.createElement(FlyoutTopLevelProperties_1.FlyoutTopLevelProperties, { transaction: transactionDoc }),
                react_1.default.createElement(eui_1.EuiHorizontalRule, null),
                react_1.default.createElement(StickyTransactionProperties_1.StickyTransactionProperties, { transaction: transactionDoc, totalDuration: waterfall.traceRootDuration }),
                react_1.default.createElement(eui_1.EuiHorizontalRule, null),
                react_1.default.createElement(DroppedSpansWarning, { transactionDoc: transactionDoc }),
                react_1.default.createElement(TransactionPropertiesTableForFlyout_1.TransactionPropertiesTableForFlyout, { transaction: transactionDoc, location: location, urlParams: urlParams })))));
}
exports.TransactionFlyout = TransactionFlyout;
