"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const constants_1 = require("../../../../../../../../common/constants");
const DatabaseContext_1 = require("./DatabaseContext");
const HttpContext_1 = require("./HttpContext");
const StickySpanProperties_1 = require("./StickySpanProperties");
const DiscoverSpanLink_1 = require("x-pack/plugins/apm/public/components/shared/Links/DiscoverLinks/DiscoverSpanLink");
const Stacktrace_1 = require("x-pack/plugins/apm/public/components/shared/Stacktrace");
const FlyoutTopLevelProperties_1 = require("../FlyoutTopLevelProperties");
const TagName = styled_components_1.default.div `
  font-weight: bold;
`;
function SpanFlyout({ span, parentTransaction, totalDuration, onClose }) {
    if (!span) {
        return null;
    }
    const stackframes = span.span.stacktrace;
    const codeLanguage = lodash_1.get(span, constants_1.SERVICE_LANGUAGE_NAME);
    const dbContext = span.context.db;
    const httpContext = span.context.http;
    const tagContext = span.context.tags;
    const tags = lodash_1.keys(tagContext).map(key => ({
        key,
        value: lodash_1.get(tagContext, key)
    }));
    return (react_1.default.createElement(eui_1.EuiPortal, null,
        react_1.default.createElement(eui_1.EuiFlyout, { onClose: onClose, size: "m", ownFocus: true },
            react_1.default.createElement(eui_1.EuiFlyoutHeader, { hasBorder: true },
                react_1.default.createElement(eui_1.EuiFlexGroup, null,
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(eui_1.EuiTitle, null,
                            react_1.default.createElement("h2", null, i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanDetailsTitle', {
                                defaultMessage: 'Span details'
                            })))),
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(DiscoverSpanLink_1.DiscoverSpanLink, { span: span },
                            react_1.default.createElement(eui_1.EuiButtonEmpty, { iconType: "discoverApp" }, i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.viewSpanInDiscoverButtonLabel', {
                                defaultMessage: 'View span in Discover'
                            })))))),
            react_1.default.createElement(eui_1.EuiFlyoutBody, null,
                react_1.default.createElement(FlyoutTopLevelProperties_1.FlyoutTopLevelProperties, { transaction: parentTransaction }),
                react_1.default.createElement(eui_1.EuiHorizontalRule, null),
                react_1.default.createElement(StickySpanProperties_1.StickySpanProperties, { span: span, totalDuration: totalDuration }),
                react_1.default.createElement(eui_1.EuiHorizontalRule, null),
                react_1.default.createElement(eui_1.EuiTabbedContent, { tabs: [
                        {
                            id: 'stack-trace',
                            name: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.stackTraceTabLabel', {
                                defaultMessage: 'Stack Trace'
                            }),
                            content: (react_1.default.createElement(react_1.Fragment, null,
                                react_1.default.createElement(eui_1.EuiSpacer, { size: "l" }),
                                react_1.default.createElement(HttpContext_1.HttpContext, { httpContext: httpContext }),
                                react_1.default.createElement(DatabaseContext_1.DatabaseContext, { dbContext: dbContext }),
                                react_1.default.createElement(Stacktrace_1.Stacktrace, { stackframes: stackframes, codeLanguage: codeLanguage })))
                        },
                        {
                            id: 'tags',
                            name: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.tagsTabLabel', {
                                defaultMessage: 'Tags'
                            }),
                            content: (react_1.default.createElement(react_1.Fragment, null,
                                react_1.default.createElement(eui_1.EuiBasicTable, { columns: [
                                        {
                                            name: '',
                                            field: 'key',
                                            render: (key) => react_1.default.createElement(TagName, null, key)
                                        },
                                        {
                                            name: '',
                                            field: 'value'
                                        }
                                    ], items: tags })))
                        }
                    ] })))));
}
exports.SpanFlyout = SpanFlyout;
