"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const constants_1 = require("x-pack/plugins/apm/common/constants");
const i18n_2 = require("x-pack/plugins/apm/common/i18n");
const formatters_1 = require("../../../../../../../utils/formatters");
const StickyProperties_1 = require("../../../../../../shared/StickyProperties");
function getSpanLabel(type) {
    switch (type) {
        case 'db':
            return 'DB';
        case 'hard-navigation':
            return i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanType.navigationTimingLabel', {
                defaultMessage: 'Navigation timing'
            });
        default:
            return type;
    }
}
function getPrimaryType(type) {
    return lodash_1.first(type.split('.'));
}
function StickySpanProperties({ span, totalDuration }) {
    if (!totalDuration) {
        return null;
    }
    const spanName = span.span.name;
    const spanDuration = span.span.duration.us;
    const spanTypeLabel = getSpanLabel(getPrimaryType(span.span.type));
    const stickyProperties = [
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.nameLabel', {
                defaultMessage: 'Name'
            }),
            fieldName: constants_1.SPAN_NAME,
            val: spanName || i18n_2.NOT_AVAILABLE_LABEL,
            truncated: true,
            width: '50%'
        },
        {
            fieldName: constants_1.SPAN_TYPE,
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.typeLabel', {
                defaultMessage: 'Type'
            }),
            val: spanTypeLabel,
            truncated: true,
            widht: '50%'
        },
        {
            fieldName: constants_1.SPAN_DURATION,
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.durationLabel', {
                defaultMessage: 'Duration'
            }),
            val: formatters_1.asMillis(spanDuration),
            width: '50%'
        },
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.spanFlyout.percentOfTransactionLabel', {
                defaultMessage: '% of transaction'
            }),
            val: formatters_1.asPercent(spanDuration, totalDuration),
            width: '50%'
        }
    ];
    return react_1.default.createElement(StickyProperties_1.StickyProperties, { stickyProperties: stickyProperties });
}
exports.StickySpanProperties = StickySpanProperties;
