"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const idx_1 = tslib_1.__importDefault(require("idx"));
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const i18n_2 = require("x-pack/plugins/apm/common/i18n");
const constants_1 = require("../../../../../common/constants");
const formatters_1 = require("../../../../utils/formatters");
const StickyProperties_1 = require("../../../shared/StickyProperties");
function StickyTransactionProperties({ transaction, totalDuration }) {
    const timestamp = transaction['@timestamp'];
    const url = idx_1.default(transaction, _ => _.context.page.url) ||
        idx_1.default(transaction, _ => _.context.request.url.full) ||
        i18n_2.NOT_AVAILABLE_LABEL;
    const duration = transaction.transaction.duration.us;
    const stickyProperties = [
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.timestampLabel', {
                defaultMessage: 'Timestamp'
            }),
            fieldName: '@timestamp',
            val: timestamp,
            truncated: true,
            width: '50%'
        },
        {
            fieldName: constants_1.REQUEST_URL_FULL,
            label: 'URL',
            val: url,
            truncated: true,
            width: '50%'
        },
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.durationLabel', {
                defaultMessage: 'Duration'
            }),
            fieldName: constants_1.TRANSACTION_DURATION,
            val: formatters_1.asTime(duration),
            width: '25%'
        },
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.percentOfTraceLabel', {
                defaultMessage: '% of trace'
            }),
            val: formatters_1.asPercent(duration, totalDuration, i18n_2.NOT_AVAILABLE_LABEL),
            width: '25%'
        },
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.resultLabel', {
                defaultMessage: 'Result'
            }),
            fieldName: constants_1.TRANSACTION_RESULT,
            val: lodash_1.get(transaction, constants_1.TRANSACTION_RESULT, i18n_2.NOT_AVAILABLE_LABEL),
            width: '25%'
        },
        {
            label: i18n_1.i18n.translate('xpack.apm.transactionDetails.userIdLabel', {
                defaultMessage: 'User ID'
            }),
            fieldName: constants_1.USER_ID,
            val: lodash_1.get(transaction, constants_1.USER_ID, i18n_2.NOT_AVAILABLE_LABEL),
            truncated: true,
            width: '25%'
        }
    ];
    return react_1.default.createElement(StickyProperties_1.StickyProperties, { stickyProperties: stickyProperties });
}
exports.StickyTransactionProperties = StickyTransactionProperties;
