"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
// @ts-ignore
const traceList_1 = require("../../../store/reactReduxRequest/traceList");
const EmptyMessage_1 = require("../../shared/EmptyMessage");
const TraceList_1 = require("./TraceList");
function TraceOverview(props) {
    const { urlParams } = props;
    return (react_1.default.createElement(traceList_1.TraceListRequest, { urlParams: urlParams, render: ({ data, status }) => (react_1.default.createElement(TraceList_1.TraceList, { items: data, isLoading: status === 'LOADING', noItemsMessage: react_1.default.createElement(EmptyMessage_1.EmptyMessage, { heading: i18n_1.i18n.translate('xpack.apm.tracesTable.notFoundLabel', {
                    defaultMessage: 'No traces found for this query'
                }) }) })) }));
}
exports.TraceOverview = TraceOverview;
