"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importStar(require("react"));
const status_check_1 = require("../../../services/rest/apm/status_check");
const serviceList_1 = require("../../../store/reactReduxRequest/serviceList");
const EmptyMessage_1 = require("../../shared/EmptyMessage");
const SetupInstructionsLink_1 = require("../../shared/SetupInstructionsLink");
const ServiceList_1 = require("./ServiceList");
class ServiceOverview extends react_1.Component {
    constructor() {
        super(...arguments);
        this.state = { historicalDataFound: true };
    }
    async checkForHistoricalData() {
        const result = await status_check_1.loadAgentStatus();
        this.setState({ historicalDataFound: result.dataFound });
    }
    componentDidMount() {
        this.checkForHistoricalData();
    }
    render() {
        const { urlParams } = this.props;
        const { historicalDataFound } = this.state;
        const noItemsMessage = (react_1.default.createElement(EmptyMessage_1.EmptyMessage, { heading: historicalDataFound
                ? i18n_1.i18n.translate('xpack.apm.servicesTable.notFoundLabel', {
                    defaultMessage: 'No services were found'
                })
                : i18n_1.i18n.translate('xpack.apm.servicesTable.noServicesLabel', {
                    defaultMessage: `Looks like you don't have any services with APM installed. Let's add some!`
                }), subheading: !historicalDataFound ? react_1.default.createElement(SetupInstructionsLink_1.SetupInstructionsLink, { buttonFill: true }) : null }));
        // Render method here uses this.props.serviceList instead of received "data" from RRR
        // to make it easier to test -- mapStateToProps uses the RRR selector so the data
        // is the same either way
        return (react_1.default.createElement("div", null,
            react_1.default.createElement(serviceList_1.ServiceListRequest, { urlParams: urlParams, render: () => (react_1.default.createElement(ServiceList_1.ServiceList, { items: this.props.serviceList.data, noItemsMessage: noItemsMessage })) })));
    }
}
exports.ServiceOverview = ServiceOverview;
