"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const react_redux_1 = require("react-redux");
const serviceList_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/serviceList");
const urlParams_1 = require("x-pack/plugins/apm/public/store/urlParams");
const view_1 = require("./view");
function mapStateToProps(state = {}) {
    return {
        serviceList: serviceList_1.getServiceList(state),
        urlParams: urlParams_1.getUrlParams(state)
    };
}
exports.ServiceOverview = react_redux_1.connect(mapStateToProps)(view_1.ServiceOverview);
