"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importDefault(require("react"));
const serviceDetails_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/serviceDetails");
// @ts-ignore
const KueryBar_1 = require("../../shared/KueryBar");
const ServiceDetailTabs_1 = require("./ServiceDetailTabs");
const ServiceIntegrations_1 = require("./ServiceIntegrations");
class ServiceDetailsView extends react_1.default.Component {
    render() {
        const { urlParams, location } = this.props;
        return (react_1.default.createElement(serviceDetails_1.ServiceDetailsRequest, { urlParams: urlParams, render: ({ data }) => {
                return (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceBetween" },
                        react_1.default.createElement(eui_1.EuiFlexItem, null,
                            react_1.default.createElement(eui_1.EuiTitle, { size: "l" },
                                react_1.default.createElement("h1", null, urlParams.serviceName))),
                        react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                            react_1.default.createElement(ServiceIntegrations_1.ServiceIntegrations, { location: this.props.location, urlParams: urlParams, serviceTransactionTypes: data.types }))),
                    react_1.default.createElement(eui_1.EuiSpacer, null),
                    react_1.default.createElement(KueryBar_1.KueryBar, null),
                    react_1.default.createElement(ServiceDetailTabs_1.ServiceDetailTabs, { location: location, urlParams: urlParams, transactionTypes: data.types })));
            } }));
    }
}
exports.ServiceDetailsView = ServiceDetailsView;
