"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
// @ts-ignore
const Distribution_1 = tslib_1.__importDefault(require("x-pack/plugins/apm/public/components/app/ErrorGroupDetails/Distribution"));
const SyncChartGroup_1 = require("x-pack/plugins/apm/public/components/shared/charts/SyncChartGroup");
const TransactionCharts_1 = require("x-pack/plugins/apm/public/components/shared/charts/TransactionCharts");
const errorDistribution_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/errorDistribution");
const serviceMetricsCharts_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/serviceMetricsCharts");
const transactionOverviewCharts_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/transactionOverviewCharts");
const CPUUsageChart_1 = require("./CPUUsageChart");
const MemoryUsageChart_1 = require("./MemoryUsageChart");
function ServiceMetrics({ urlParams, location }) {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(transactionOverviewCharts_1.TransactionOverviewChartsRequestForAllTypes, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(TransactionCharts_1.TransactionCharts, { charts: data, urlParams: urlParams, location: location })) }),
        react_1.default.createElement(eui_1.EuiSpacer, { size: "xxl" }),
        react_1.default.createElement(eui_1.EuiFlexGroup, null,
            react_1.default.createElement(eui_1.EuiFlexItem, null,
                react_1.default.createElement(errorDistribution_1.ErrorDistributionRequest, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(Distribution_1.default, { distribution: data, title: react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
                            react_1.default.createElement("span", null, i18n_1.i18n.translate('xpack.apm.serviceDetails.metrics.errorOccurrencesChartTitle', {
                                defaultMessage: 'Error occurrences'
                            }))) })) }))),
        react_1.default.createElement(eui_1.EuiSpacer, { size: "xxl" }),
        react_1.default.createElement(serviceMetricsCharts_1.MetricsChartDataRequest, { urlParams: urlParams, render: ({ data }) => {
                return (react_1.default.createElement(SyncChartGroup_1.SyncChartGroup, { render: hoverXHandlers => (react_1.default.createElement(eui_1.EuiFlexGrid, { columns: 2 },
                        react_1.default.createElement(eui_1.EuiFlexItem, null,
                            react_1.default.createElement(CPUUsageChart_1.CPUUsageChart, { data: data.cpu, hoverXHandlers: hoverXHandlers })),
                        react_1.default.createElement(eui_1.EuiFlexItem, null,
                            react_1.default.createElement(MemoryUsageChart_1.MemoryUsageChart, { data: data.memory, hoverXHandlers: hoverXHandlers })))) }));
            } }),
        react_1.default.createElement(eui_1.EuiSpacer, { size: "xxl" })));
}
exports.ServiceMetrics = ServiceMetrics;
