"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const react_redux_1 = require("react-redux");
const license_1 = require("x-pack/plugins/apm/public/store/selectors/license");
const view_1 = require("./view");
function mapStateToProps(state = {}) {
    return {
        mlAvailable: license_1.selectIsMLAvailable(state)
    };
}
const ServiceIntegrations = react_redux_1.connect(mapStateToProps)(view_1.ServiceIntegrationsView);
exports.ServiceIntegrations = ServiceIntegrations;
