"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
exports.TransactionSelect = ({ existingJobs, types, selected, onChange }) => {
    return (react_1.default.createElement(eui_1.EuiFormRow, { label: i18n_1.i18n.translate('xpack.apm.serviceDetails.enableAnomalyDetectionPanel.selectTransactionTypeLabel', {
            defaultMessage: 'Select a transaction type for this job'
        }) },
        react_1.default.createElement(eui_1.EuiSuperSelect, { valueOfSelected: selected, onChange: onChange, options: types.map((type, i) => ({
                value: type,
                inputDisplay: type,
                dropdownDisplay: (react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceBetween" },
                    react_1.default.createElement(eui_1.EuiFlexItem, null,
                        react_1.default.createElement(eui_1.EuiText, null, type)),
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false }, Boolean(existingJobs.find(job => job.jobId && job.jobId.includes(type))) ? (react_1.default.createElement(eui_1.EuiToolTip, { content: i18n_1.i18n.translate('xpack.apm.serviceDetails.enableAnomalyDetectionPanel.existedJobTooltip', {
                            defaultMessage: 'ML job exists for this type'
                        }) },
                        react_1.default.createElement(eui_1.EuiIcon, { type: "machineLearningApp" }))) : (react_1.default.createElement(eui_1.EuiIcon, { type: "empty" })))))
            })) })));
};
