"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
// @ts-ignore
const CustomPlot_1 = tslib_1.__importDefault(require("x-pack/plugins/apm/public/components/shared/charts/CustomPlot"));
const formatters_1 = require("x-pack/plugins/apm/public/utils/formatters");
function CPUUsageChart({ data, hoverXHandlers }) {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
            react_1.default.createElement("span", null, i18n_1.i18n.translate('xpack.apm.serviceDetails.metrics.cpuUsageChartTitle', {
                defaultMessage: 'CPU usage'
            }))),
        react_1.default.createElement(CustomPlot_1.default, Object.assign({}, hoverXHandlers, { noHits: data.totalHits === 0, series: data.series, tickFormatY: (y) => `${(y || 0) * 100}%`, formatTooltipValue: (c) => formatters_1.asPercent(c.y || 0, 1), yMax: 1 }))));
}
exports.CPUUsageChart = CPUUsageChart;
