"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
// @ts-ignore
const Distribution_1 = tslib_1.__importDefault(require("x-pack/plugins/apm/public/components/app/ErrorGroupDetails/Distribution"));
const errorDistribution_1 = require("x-pack/plugins/apm/public/store/reactReduxRequest/errorDistribution");
const errorGroupList_1 = require("../../../store/reactReduxRequest/errorGroupList");
// @ts-ignore
const List_1 = require("./List");
const ErrorGroupOverview = ({ urlParams, location }) => {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(eui_1.EuiFlexGroup, null,
            react_1.default.createElement(eui_1.EuiFlexItem, null,
                react_1.default.createElement(errorDistribution_1.ErrorDistributionRequest, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(Distribution_1.default, { distribution: data, title: react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
                            react_1.default.createElement("span", null, i18n_1.i18n.translate('xpack.apm.serviceDetails.metrics.errorOccurrencesChartTitle', {
                                defaultMessage: 'Error occurrences'
                            }))) })) }))),
        react_1.default.createElement(eui_1.EuiSpacer, { size: "l" }),
        react_1.default.createElement(errorGroupList_1.ErrorGroupOverviewRequest, { urlParams: urlParams, render: ({ data }) => (react_1.default.createElement(List_1.ErrorGroupList, { urlParams: urlParams, items: data, location: location })) })));
};
exports.ErrorGroupOverview = ErrorGroupOverview;
