"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const i18n_2 = require("x-pack/plugins/apm/common/i18n");
const constants_1 = require("../../../../common/constants");
const errorDistribution_1 = require("../../../store/reactReduxRequest/errorDistribution");
const errorGroup_1 = require("../../../store/reactReduxRequest/errorGroup");
const variables_1 = require("../../../style/variables");
// @ts-ignore
const KueryBar_1 = require("../../shared/KueryBar");
const DetailView_1 = require("./DetailView");
// @ts-ignore
const Distribution_1 = tslib_1.__importDefault(require("./Distribution"));
const Titles = styled_components_1.default.div `
  margin-bottom: ${variables_1.px(variables_1.units.plus)};
`;
const UnhandledBadge = styled_components_1.default(eui_1.EuiBadge) `
  margin-left: ${variables_1.px(variables_1.unit)};
  margin-top: -${variables_1.px(variables_1.units.half - 1)};
`;
const Label = styled_components_1.default.div `
  margin-bottom: ${variables_1.px(variables_1.units.quarter)};
  font-size: ${variables_1.fontSizes.small};
  color: ${variables_1.colors.gray3};
`;
const Message = styled_components_1.default.div `
  font-family: ${variables_1.fontFamilyCode};
  font-weight: bold;
  font-size: ${variables_1.fontSizes.large};
  margin-bottom: ${variables_1.px(variables_1.units.half)};
`;
const Culprit = styled_components_1.default.div `
  font-family: ${variables_1.fontFamilyCode};
`;
function getShortGroupId(errorGroupId) {
    if (!errorGroupId) {
        return i18n_2.NOT_AVAILABLE_LABEL;
    }
    return errorGroupId.slice(0, 5);
}
function ErrorGroupDetails({ urlParams, location }) {
    return (react_1.default.createElement(errorGroup_1.ErrorGroupDetailsRequest, { urlParams: urlParams, render: errorGroup => {
            // If there are 0 occurrences, show only distribution chart w. empty message
            const showDetails = errorGroup.data.occurrencesCount !== 0;
            const logMessage = lodash_1.get(errorGroup.data.error, constants_1.ERROR_LOG_MESSAGE);
            const excMessage = lodash_1.get(errorGroup.data.error, constants_1.ERROR_EXC_MESSAGE);
            const culprit = lodash_1.get(errorGroup.data.error, constants_1.ERROR_CULPRIT);
            const isUnhandled = lodash_1.get(errorGroup.data.error, constants_1.ERROR_EXC_HANDLED) === false;
            return (react_1.default.createElement("div", null,
                react_1.default.createElement(eui_1.EuiTitle, null,
                    react_1.default.createElement("span", null,
                        i18n_1.i18n.translate('xpack.apm.errorGroupDetails.errorGroupTitle', {
                            defaultMessage: 'Error group {errorGroupId}',
                            values: {
                                errorGroupId: getShortGroupId(urlParams.errorGroupId)
                            }
                        }),
                        isUnhandled && (react_1.default.createElement(UnhandledBadge, { color: "warning" }, i18n_1.i18n.translate('xpack.apm.errorGroupDetails.unhandledLabel', {
                            defaultMessage: 'Unhandled'
                        }))))),
                react_1.default.createElement(eui_1.EuiSpacer, { size: "m" }),
                react_1.default.createElement(KueryBar_1.KueryBar, null),
                react_1.default.createElement(eui_1.EuiSpacer, { size: "s" }),
                showDetails && (react_1.default.createElement(Titles, null,
                    react_1.default.createElement(eui_1.EuiText, null,
                        logMessage && (react_1.default.createElement(react_1.Fragment, null,
                            react_1.default.createElement(Label, null, i18n_1.i18n.translate('xpack.apm.errorGroupDetails.logMessageLabel', {
                                defaultMessage: 'Log message'
                            })),
                            react_1.default.createElement(Message, null, logMessage))),
                        react_1.default.createElement(Label, null, i18n_1.i18n.translate('xpack.apm.errorGroupDetails.exceptionMessageLabel', {
                            defaultMessage: 'Exception message'
                        })),
                        react_1.default.createElement(Message, null, excMessage || i18n_2.NOT_AVAILABLE_LABEL),
                        react_1.default.createElement(Label, null, i18n_1.i18n.translate('xpack.apm.errorGroupDetails.culpritLabel', {
                            defaultMessage: 'Culprit'
                        })),
                        react_1.default.createElement(Culprit, null, culprit || i18n_2.NOT_AVAILABLE_LABEL)))),
                react_1.default.createElement(errorDistribution_1.ErrorDistributionRequest, { urlParams: urlParams, render: ({ data }) => react_1.default.createElement(Distribution_1.default, { distribution: data }) }),
                showDetails && (react_1.default.createElement(DetailView_1.DetailView, { errorGroup: errorGroup, urlParams: urlParams, location: location }))));
        } }));
}
exports.ErrorGroupDetails = ErrorGroupDetails;
