'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _remarkable = require('remarkable');

var _remarkable2 = _interopRequireDefault(_remarkable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var MarkdownRenderer = function MarkdownRenderer(_ref) {
  var markdown = _ref.markdown,
      _ref$options = _ref.options;
  _ref$options = _ref$options === undefined ? {} : _ref$options;

  var preset = _ref$options.preset,
      options = _objectWithoutProperties(_ref$options, ['preset']),
      props = _objectWithoutProperties(_ref, ['markdown', 'options']);

  var remarkable = new _remarkable2.default(preset || 'default', options);
  var html = remarkable.render(markdown);

  return _react2.default.createElement('div', _extends({}, props, { dangerouslySetInnerHTML: { __html: html } }));
};

MarkdownRenderer.propTypes = {
  markdown: require('prop-types').string.isRequired,
  options: require('prop-types').shape({
    preset: require('prop-types').oneOf(['default', 'commonmark', 'full']),
    html: require('prop-types').bool,
    xhtmlOut: require('prop-types').bool,
    breaks: require('prop-types').bool,
    langPrefix: require('prop-types').string,
    linkify: require('prop-types').bool,
    typographer: require('prop-types').bool,
    quotes: require('prop-types').string,
    highlight: require('prop-types').func
  })
};
exports.default = MarkdownRenderer;