/*(c) Copyright 2015 Pivotal Software, Inc. All Rights Reserved.*/
'use strict';

exports.__esModule = true;
exports.DropdownItem = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DropdownItem = exports.DropdownItem = function (_React$Component) {
  (0, _inherits3.default)(DropdownItem, _React$Component);

  function DropdownItem() {
    var _temp, _this, _ret;

    (0, _classCallCheck3.default)(this, DropdownItem);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.handleClick = function (event) {
      var _this$props = _this.props,
          href = _this$props.href,
          disabled = _this$props.disabled,
          onClick = _this$props.onClick,
          onSelect = _this$props.onSelect,
          eventKey = _this$props.eventKey;

      if (disabled) return;

      if (!href) {
        event.preventDefault();
      }

      if (onSelect) {
        onSelect(event, eventKey);
      }

      if (onClick) {
        onClick(event);
      }
    }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
  }

  DropdownItem.prototype.componentDidMount = function componentDidMount() {
    require('../../css/dropdowns');
  };

  DropdownItem.prototype.render = function render() {
    // eslint-disable-next-line no-unused-vars
    var _props = this.props,
        children = _props.children,
        className = _props.className,
        eventKey = _props.eventKey,
        style = _props.style,
        href = _props.href,
        header = _props.header,
        divider = _props.divider,
        disabled = _props.disabled,
        onClick = _props.onClick,
        onSelect = _props.onSelect,
        anchorProps = (0, _objectWithoutProperties3.default)(_props, ['children', 'className', 'eventKey', 'style', 'href', 'header', 'divider', 'disabled', 'onClick', 'onSelect']);


    if (header) return _react2.default.createElement(
      'li',
      { role: 'heading', className: 'dropdown-header' },
      children
    );
    if (divider) return _react2.default.createElement('li', { role: 'separator', className: 'divider' });

    var anchor = href ? _react2.default.createElement(
      'a',
      (0, _extends3.default)({ href: href, disabled: disabled }, anchorProps),
      children
    ) : children;
    var disabledClass = disabled ? 'disabled' : '';
    var dropdownItemClass = (0, _classnames2.default)(className, disabledClass);

    return _react2.default.createElement(
      'li',
      (0, _extends3.default)({ style: style }, { className: dropdownItemClass, onClick: this.handleClick }),
      anchor
    );
  };

  return DropdownItem;
}(_react2.default.Component);

DropdownItem.propTypes = {
  className: _propTypes2.default.string,
  style: _propTypes2.default.object,
  href: _propTypes2.default.string,
  header: _propTypes2.default.bool,
  divider: _propTypes2.default.bool,
  disabled: _propTypes2.default.bool,
  eventKey: _propTypes2.default.string,
  onSelect: _propTypes2.default.func,
  onClick: _propTypes2.default.func
};