// Generated by CoffeeScript 1.12.6
(function() {
  var Data;

  Data = (function() {
    function Data(data) {
      this.data = data != null ? data : [];
      this.pos = 0;
      this.length = this.data.length;
    }

    Data.prototype.readByte = function() {
      return this.data[this.pos++];
    };

    Data.prototype.writeByte = function(byte) {
      return this.data[this.pos++] = byte;
    };

    Data.prototype.byteAt = function(index) {
      return this.data[index];
    };

    Data.prototype.readBool = function() {
      return !!this.readByte();
    };

    Data.prototype.writeBool = function(val) {
      return this.writeByte(val ? 1 : 0);
    };

    Data.prototype.readUInt32 = function() {
      var b1, b2, b3, b4;
      b1 = this.readByte() * 0x1000000;
      b2 = this.readByte() << 16;
      b3 = this.readByte() << 8;
      b4 = this.readByte();
      return b1 + b2 + b3 + b4;
    };

    Data.prototype.writeUInt32 = function(val) {
      this.writeByte((val >>> 24) & 0xff);
      this.writeByte((val >> 16) & 0xff);
      this.writeByte((val >> 8) & 0xff);
      return this.writeByte(val & 0xff);
    };

    Data.prototype.readInt32 = function() {
      var int;
      int = this.readUInt32();
      if (int >= 0x80000000) {
        return int - 0x100000000;
      } else {
        return int;
      }
    };

    Data.prototype.writeInt32 = function(val) {
      if (val < 0) {
        val += 0x100000000;
      }
      return this.writeUInt32(val);
    };

    Data.prototype.readUInt16 = function() {
      var b1, b2;
      b1 = this.readByte() << 8;
      b2 = this.readByte();
      return b1 | b2;
    };

    Data.prototype.writeUInt16 = function(val) {
      this.writeByte((val >> 8) & 0xff);
      return this.writeByte(val & 0xff);
    };

    Data.prototype.readInt16 = function() {
      var int;
      int = this.readUInt16();
      if (int >= 0x8000) {
        return int - 0x10000;
      } else {
        return int;
      }
    };

    Data.prototype.writeInt16 = function(val) {
      if (val < 0) {
        val += 0x10000;
      }
      return this.writeUInt16(val);
    };

    Data.prototype.readString = function(length) {
      var i, j, ref, ret;
      ret = [];
      for (i = j = 0, ref = length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        ret[i] = String.fromCharCode(this.readByte());
      }
      return ret.join('');
    };

    Data.prototype.writeString = function(val) {
      var i, j, ref, results;
      results = [];
      for (i = j = 0, ref = val.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        results.push(this.writeByte(val.charCodeAt(i)));
      }
      return results;
    };

    Data.prototype.stringAt = function(pos, length) {
      this.pos = pos;
      return this.readString(length);
    };

    Data.prototype.readShort = function() {
      return this.readInt16();
    };

    Data.prototype.writeShort = function(val) {
      return this.writeInt16(val);
    };

    Data.prototype.readLongLong = function() {
      var b1, b2, b3, b4, b5, b6, b7, b8;
      b1 = this.readByte();
      b2 = this.readByte();
      b3 = this.readByte();
      b4 = this.readByte();
      b5 = this.readByte();
      b6 = this.readByte();
      b7 = this.readByte();
      b8 = this.readByte();
      if (b1 & 0x80) {
        return ((b1 ^ 0xff) * 0x100000000000000 + (b2 ^ 0xff) * 0x1000000000000 + (b3 ^ 0xff) * 0x10000000000 + (b4 ^ 0xff) * 0x100000000 + (b5 ^ 0xff) * 0x1000000 + (b6 ^ 0xff) * 0x10000 + (b7 ^ 0xff) * 0x100 + (b8 ^ 0xff) + 1) * -1;
      }
      return b1 * 0x100000000000000 + b2 * 0x1000000000000 + b3 * 0x10000000000 + b4 * 0x100000000 + b5 * 0x1000000 + b6 * 0x10000 + b7 * 0x100 + b8;
    };

    Data.prototype.writeLongLong = function(val) {
      var high, low;
      high = Math.floor(val / 0x100000000);
      low = val & 0xffffffff;
      this.writeByte((high >> 24) & 0xff);
      this.writeByte((high >> 16) & 0xff);
      this.writeByte((high >> 8) & 0xff);
      this.writeByte(high & 0xff);
      this.writeByte((low >> 24) & 0xff);
      this.writeByte((low >> 16) & 0xff);
      this.writeByte((low >> 8) & 0xff);
      return this.writeByte(low & 0xff);
    };

    Data.prototype.readInt = function() {
      return this.readInt32();
    };

    Data.prototype.writeInt = function(val) {
      return this.writeInt32(val);
    };

    Data.prototype.slice = function(start, end) {
      return this.data.slice(start, end);
    };

    Data.prototype.read = function(bytes) {
      var buf, i, j, ref;
      buf = [];
      for (i = j = 0, ref = bytes; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        buf.push(this.readByte());
      }
      return buf;
    };

    Data.prototype.write = function(bytes) {
      var byte, j, len, results;
      results = [];
      for (j = 0, len = bytes.length; j < len; j++) {
        byte = bytes[j];
        results.push(this.writeByte(byte));
      }
      return results;
    };

    return Data;

  })();

  module.exports = Data;

}).call(this);
