"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const create_base_path_1 = require("../../lib/create_base_path");
const metric_aggregation_creators_1 = require("../../metric_aggregation_creators");
exports.metricBucketsProcessor = (options) => {
    return (doc) => {
        const result = lodash_1.cloneDeep(doc);
        const { metric, groupBy } = options.nodeOptions;
        const path = create_base_path_1.createBasePath(groupBy).concat(['timeseries', 'aggs']);
        const aggregationCreator = metric_aggregation_creators_1.metricAggregationCreators[metric.type];
        const aggs = aggregationCreator(options.nodeType);
        lodash_1.set(result, path, aggs);
        return result;
    };
};
