"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const create_query_1 = require("../../lib/create_query");
exports.queryProcessor = (options) => {
    return (doc) => {
        const result = lodash_1.cloneDeep(doc);
        lodash_1.set(result, 'size', 0);
        lodash_1.set(result, 'query', create_query_1.createQuery(options.nodeOptions));
        return result;
    };
};
