"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const type_guards_1 = require("../../lib/type_guards");
exports.groupByProcessor = (options) => {
    return (doc) => {
        const result = lodash_1.cloneDeep(doc);
        const { groupBy } = options.nodeOptions;
        let aggs = lodash_1.get(result, 'aggs.waffle.aggs.nodes.aggs', {});
        lodash_1.set(result, 'aggs.waffle.aggs.nodes.aggs', aggs);
        groupBy.forEach((grouping, index) => {
            if (type_guards_1.isGroupByTerms(grouping)) {
                const termsAgg = {
                    aggs: {},
                    terms: {
                        field: grouping.field,
                        size: 10,
                    },
                };
                lodash_1.set(aggs, `path_${index}`, termsAgg);
                aggs = termsAgg.aggs;
            }
            if (grouping && type_guards_1.isGroupByFilters(grouping)) {
                const filtersAgg = {
                    aggs: {},
                    filters: {
                        filters: grouping.filters.map((filter) => {
                            return {
                                query_string: {
                                    analyze_wildcard: true,
                                    query: (filter && filter.query) || '*',
                                },
                            };
                        }),
                    },
                };
                lodash_1.set(aggs, `path_${index}`, filtersAgg);
                aggs = filtersAgg.aggs;
            }
        });
        return result;
    };
};
