"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const create_node_item_1 = require("./create_node_item");
function extractGroupPaths(options, node) {
    const { groupBy } = options;
    const secondGroup = groupBy[1];
    const paths = node.path_0.buckets.reduce((acc, bucket, index) => {
        const key = (bucket.key || index).toString();
        if (secondGroup) {
            return acc.concat(bucket.path_1.buckets.map((b) => {
                const innerNode = create_node_item_1.createNodeItem(options, node, b);
                const groupPaths = [
                    { value: bucket.key.toString(), label: bucket.key.toString() },
                    { value: b.key.toString(), label: b.key.toString() },
                ];
                const nodePath = groupPaths.concat(innerNode.path);
                return {
                    ...innerNode,
                    path: nodePath,
                };
            }));
        }
        const nodeItem = create_node_item_1.createNodeItem(options, node, bucket);
        const currentPath = [{ value: key, label: key }];
        const path = currentPath.concat(nodeItem.path);
        return acc.concat({
            ...nodeItem,
            path,
        });
    }, []);
    return paths;
}
exports.extractGroupPaths = extractGroupPaths;
