"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const types_1 = require("../../../graphql/types");
const adapter_types_1 = require("./adapter_types");
const getNodeType = (type) => {
    switch (type) {
        case types_1.InfraPathType.pods:
            return adapter_types_1.InfraNodeType.pod;
        case types_1.InfraPathType.containers:
            return adapter_types_1.InfraNodeType.container;
        case types_1.InfraPathType.hosts:
            return adapter_types_1.InfraNodeType.host;
        default:
            throw new Error('Invalid InfraPathType');
    }
};
const isEntityType = (path) => {
    if (!path) {
        return false;
    }
    switch (path.type) {
        case types_1.InfraPathType.containers:
        case types_1.InfraPathType.hosts:
        case types_1.InfraPathType.pods:
            return true;
        default:
            return false;
    }
};
const moreThenOneEntityType = (path) => {
    return path.filter(isEntityType).length > 1;
};
function extractGroupByAndNodeFromPath(path) {
    if (moreThenOneEntityType(path)) {
        throw new Error('There can be only one entity type in the path.');
    }
    if (path.length > 3) {
        throw new Error('The path can only have a maximum of 3 elements.');
    }
    const nodePart = path[path.length - 1];
    if (!isEntityType(nodePart)) {
        throw new Error('The last element in the path should be either a "hosts", "containers" or "pods" path type.');
    }
    const nodeType = getNodeType(nodePart.type);
    const groupBy = path.slice(0, path.length - 1);
    return { groupBy, nodeType };
}
exports.extractGroupByAndNodeFromPath = extractGroupByAndNodeFromPath;
