"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const calculate_cardinality_1 = require("./lib/calculate_cardinality");
const create_partition_bodies_1 = require("./lib/create_partition_bodies");
const process_nodes_1 = require("./lib/process_nodes");
class ElasticsearchNodesAdapter {
    constructor(framework) {
        this.framework = framework;
    }
    async getNodes(req, options) {
        const search = (searchOptions) => this.framework.callWithRequest(req, 'search', searchOptions);
        const msearch = (msearchOptions) => this.framework.callWithRequest(req, 'msearch', msearchOptions);
        const nodeField = options.sourceConfiguration.fields[options.nodeType];
        const totalNodes = await calculate_cardinality_1.calculateCardinalityOfNodeField(search, nodeField, options);
        if (totalNodes === 0) {
            return [];
        }
        const body = create_partition_bodies_1.createPartitionBodies(totalNodes, options.nodeType, nodeField, options);
        const response = await msearch({
            body,
        });
        if (response && response.responses) {
            const nodeBuckets = response.responses.reduce((current, resp) => {
                if (!resp.aggregations) {
                    return current;
                }
                const buckets = resp.aggregations.waffle.nodes.buckets;
                return current.concat(buckets);
            }, []);
            return process_nodes_1.processNodes(options, nodeBuckets);
        }
        return [];
    }
}
exports.ElasticsearchNodesAdapter = ElasticsearchNodesAdapter;
