"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const infra_server_1 = require("./infra_server");
const kibana_1 = require("./lib/compose/kibana");
const usage_collector_1 = require("./usage/usage_collector");
exports.initServerWithKibana = (kbnServer) => {
    const libs = kibana_1.compose(kbnServer);
    infra_server_1.initInfraServer(libs);
    // Register a function with server to manage the collection of usage stats
    kbnServer.usage.collectorSet.register(usage_collector_1.UsageCollector.getUsageCollector(kbnServer));
};
exports.getConfigSchema = (Joi) => {
    const InfraDefaultSourceConfigSchema = Joi.object({
        metricAlias: Joi.string(),
        logAlias: Joi.string(),
        fields: Joi.object({
            container: Joi.string(),
            host: Joi.string(),
            message: Joi.array()
                .items(Joi.string())
                .single(),
            pod: Joi.string(),
            tiebreaker: Joi.string(),
            timestamp: Joi.string(),
        }),
    });
    const InfraRootConfigSchema = Joi.object({
        enabled: Joi.boolean().default(true),
        query: Joi.object({
            partitionSize: Joi.number(),
            partitionFactor: Joi.number(),
        }).default(),
        sources: Joi.object()
            .keys({
            default: InfraDefaultSourceConfigSchema,
        })
            .default(),
    }).default();
    return InfraRootConfigSchema;
};
