"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const source_configuration_1 = require("../../../common/source_configuration");
exports.createSourcesResolvers = (libs) => ({
    Query: {
        async source(root, args, { req }) {
            const requestedSourceConfiguration = await libs.sources.getSourceConfiguration(req, args.id);
            return requestedSourceConfiguration;
        },
        async allSources(root, args, { req }) {
            const sourceConfigurations = await libs.sources.getAllSourceConfigurations(req);
            return sourceConfigurations;
        },
    },
    InfraSource: {
        async status(source) {
            return source;
        },
    },
    Mutation: {
        async createSource(root, args, { req }) {
            const sourceConfiguration = await libs.sources.createSourceConfiguration(req, args.id, compactObject({
                ...args.source,
                fields: args.source.fields ? compactObject(args.source.fields) : undefined,
            }));
            return {
                source: sourceConfiguration,
            };
        },
        async deleteSource(root, args, { req }) {
            await libs.sources.deleteSourceConfiguration(req, args.id);
            return {
                id: args.id,
            };
        },
        async updateSource(root, args, { req }) {
            const updaters = args.changes.map(source_configuration_1.convertChangeToUpdater);
            const updatedSourceConfiguration = await libs.sources.updateSourceConfiguration(req, args.id, updaters);
            return {
                source: updatedSourceConfiguration,
            };
        },
    },
});
const compactObject = (obj) => Object.entries(obj).reduce((accumulatedObj, [key, value]) => typeof value === 'undefined' || value === null
    ? accumulatedObj
    : {
        ...accumulatedObj,
        [key]: value,
    }, {});
