"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const last_1 = tslib_1.__importDefault(require("lodash/fp/last"));
const isFailedStatus = (status) => status.status === 'failed';
exports.createStatusSelectors = (selectStatusHistory) => ({
    getIsInProgress: () => (state) => {
        const lastStatus = last_1.default(selectStatusHistory(state));
        return lastStatus ? lastStatus.status === 'in-progress' : false;
    },
    getHasSucceeded: () => (state) => {
        const lastStatus = last_1.default(selectStatusHistory(state));
        return lastStatus ? lastStatus.status === 'succeeded' : false;
    },
    getHasFailed: () => (state) => {
        const lastStatus = last_1.default(selectStatusHistory(state));
        return lastStatus ? lastStatus.status === 'failed' : false;
    },
    getLastFailureMessage: () => (state) => {
        const lastStatus = last_1.default(selectStatusHistory(state).filter(isFailedStatus));
        return lastStatus ? lastStatus.message : undefined;
    },
});
exports.createStatusActions = (updateStatusHistory) => ({
    startOperation: (operation) => updateStatusHistory(statusHistory => [
        ...statusHistory,
        {
            operation,
            status: 'in-progress',
            time: Date.now(),
        },
    ]),
    finishOperation: (operation) => updateStatusHistory(statusHistory => [
        ...statusHistory,
        {
            operation,
            status: 'succeeded',
            time: Date.now(),
        },
    ]),
    failOperation: (operation, message) => updateStatusHistory(statusHistory => [
        ...statusHistory,
        {
            message,
            operation,
            status: 'failed',
            time: Date.now(),
        },
    ]),
});
