"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const redux_observable_1 = require("redux-observable");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const __1 = require("../..");
const actions_1 = require("./actions");
const load_1 = require("./operations/load");
const LOAD_BUCKETS_PER_PAGE = 100;
const MINIMUM_BUCKETS_PER_PAGE = 90;
const MINIMUM_BUFFER_PAGES = 0.5;
exports.createLogSummaryEpic = () => redux_observable_1.combineEpics(exports.createSummaryEffectsEpic(), load_1.loadSummaryEpic);
exports.createSummaryEffectsEpic = () => (action$, state$, { selectLogFilterQueryAsJson, selectVisibleLogSummary }) => {
    const filterQuery$ = state$.pipe(operators_1.map(selectLogFilterQueryAsJson));
    const summaryInterval$ = state$.pipe(operators_1.map(selectVisibleLogSummary), operators_1.map(({ start, end }) => (start && end ? getLoadParameters(start, end) : null)), operators_1.filter(isNotNull));
    const shouldLoadBetweenNewInterval$ = action$.pipe(operators_1.filter(__1.logPositionActions.reportVisibleSummary.match), operators_1.filter(({ payload: { bucketsOnPage, pagesBeforeStart, pagesAfterEnd } }) => bucketsOnPage < MINIMUM_BUCKETS_PER_PAGE ||
        pagesBeforeStart < MINIMUM_BUFFER_PAGES ||
        pagesAfterEnd < MINIMUM_BUFFER_PAGES), operators_1.map(({ payload: { start, end } }) => getLoadParameters(start, end)));
    const shouldLoadWithNewFilter$ = action$.pipe(operators_1.filter(__1.logFilterActions.applyLogFilterQuery.match), operators_1.withLatestFrom(filterQuery$, (filterQuery, filterQueryString) => filterQueryString));
    return rxjs_1.merge(shouldLoadBetweenNewInterval$.pipe(operators_1.withLatestFrom(filterQuery$), operators_1.exhaustMap(([{ start, end, bucketSize }, filterQuery]) => [
        actions_1.loadSummary({
            start,
            end,
            sourceId: 'default',
            bucketSize,
            filterQuery,
        }),
    ])), shouldLoadWithNewFilter$.pipe(operators_1.withLatestFrom(summaryInterval$), operators_1.exhaustMap(([filterQuery, { start, end, bucketSize }]) => [
        actions_1.loadSummary({
            start,
            end,
            sourceId: 'default',
            bucketSize: (end - start) / LOAD_BUCKETS_PER_PAGE,
            filterQuery,
        }),
    ])));
};
const getLoadParameters = (start, end) => ({
    start: start - (end - start),
    end: end + (end - start),
    bucketSize: (end - start) / LOAD_BUCKETS_PER_PAGE,
});
const isNotNull = (value) => value !== null;
