"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const remote_graphql_state_1 = require("../../../../utils/remote_state/remote_graphql_state");
const state_1 = require("../state");
const log_entries_gql_query_1 = require("./log_entries.gql_query");
const operationKey = 'load';
exports.loadEntriesActionCreators = remote_graphql_state_1.createGraphqlOperationActionCreators('log_entries', operationKey);
exports.loadEntriesReducer = remote_graphql_state_1.createGraphqlOperationReducer(operationKey, state_1.initialLogEntriesState, exports.loadEntriesActionCreators, (state, action) => action.payload.result.data.source.logEntriesAround);
exports.loadEntriesEpic = remote_graphql_state_1.createGraphqlQueryEpic(log_entries_gql_query_1.logEntriesQuery, exports.loadEntriesActionCreators);
