"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const moment_1 = tslib_1.__importDefault(require("moment"));
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const actions_1 = require("./actions");
exports.createMetricTimeEpic = () => (action$, state$, { selectMetricTimeUpdatePolicyInterval, selectMetricRangeFromTimeRange }) => {
    const updateInterval$ = state$.pipe(operators_1.map(selectMetricTimeUpdatePolicyInterval), operators_1.filter(isNotNull));
    const range$ = state$.pipe(operators_1.map(selectMetricRangeFromTimeRange), operators_1.filter(isNotNull));
    return action$.pipe(operators_1.filter(actions_1.startMetricsAutoReload.match), operators_1.withLatestFrom(updateInterval$, range$), operators_1.exhaustMap(([action, updateInterval, range]) => rxjs_1.timer(0, updateInterval).pipe(operators_1.map(() => actions_1.setRangeTime({
        from: moment_1.default()
            .subtract(range, 'ms')
            .valueOf(),
        to: moment_1.default().valueOf(),
        interval: '1m',
    })), operators_1.takeUntil(action$.pipe(operators_1.filter(actions_1.stopMetricsAutoReload.match))))));
};
const isNotNull = (value) => value !== null;
