"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_router_dom_1 = require("react-router-dom");
const _404_1 = require("./pages/404");
const home_1 = require("./pages/home");
const link_to_1 = require("./pages/link_to");
const logs_1 = require("./pages/logs");
const metrics_1 = require("./pages/metrics");
exports.PageRouter = ({ history }) => {
    return (react_1.default.createElement(react_router_dom_1.Router, { history: history },
        react_1.default.createElement(react_router_dom_1.Switch, null,
            react_1.default.createElement(react_router_dom_1.Redirect, { from: "/", exact: true, to: "/home" }),
            react_1.default.createElement(react_router_dom_1.Route, { path: "/logs", component: logs_1.LogsPage }),
            react_1.default.createElement(react_router_dom_1.Route, { path: "/home", component: home_1.HomePage }),
            react_1.default.createElement(react_router_dom_1.Route, { path: "/link-to", component: link_to_1.LinkToPage }),
            react_1.default.createElement(react_router_dom_1.Route, { path: "/metrics/:type/:node", component: metrics_1.MetricDetail }),
            react_1.default.createElement(react_router_dom_1.Route, { component: _404_1.NotFoundPage }))));
};
