"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const autocomplete_field_1 = require("../../components/autocomplete_field");
const eui_2 = require("../../components/eui");
const log_customization_menu_1 = require("../../components/logging/log_customization_menu");
const log_minimap_scale_controls_1 = require("../../components/logging/log_minimap_scale_controls");
const log_text_scale_controls_1 = require("../../components/logging/log_text_scale_controls");
const log_text_wrap_controls_1 = require("../../components/logging/log_text_wrap_controls");
const log_time_controls_1 = require("../../components/logging/log_time_controls");
const source_configuration_1 = require("../../components/source_configuration");
const with_log_filter_1 = require("../../containers/logs/with_log_filter");
const with_log_minimap_1 = require("../../containers/logs/with_log_minimap");
const with_log_position_1 = require("../../containers/logs/with_log_position");
const with_log_textview_1 = require("../../containers/logs/with_log_textview");
const with_kuery_autocompletion_1 = require("../../containers/with_kuery_autocompletion");
const with_source_1 = require("../../containers/with_source");
exports.LogsToolbar = react_1.injectI18n(({ intl }) => (react_2.default.createElement(eui_2.Toolbar, null,
    react_2.default.createElement(with_source_1.WithSource, null, ({ configuration, derivedIndexPattern }) => (react_2.default.createElement(eui_1.EuiFlexGroup, { alignItems: "center", justifyContent: "spaceBetween", gutterSize: "s" },
        react_2.default.createElement(eui_1.EuiFlexItem, null,
            react_2.default.createElement(with_kuery_autocompletion_1.WithKueryAutocompletion, { indexPattern: derivedIndexPattern }, ({ isLoadingSuggestions, loadSuggestions, suggestions }) => (react_2.default.createElement(with_log_filter_1.WithLogFilter, { indexPattern: derivedIndexPattern }, ({ applyFilterQueryFromKueryExpression, filterQueryDraft, isFilterQueryDraftValid, setFilterQueryDraftFromKueryExpression, }) => (react_2.default.createElement(autocomplete_field_1.AutocompleteField, { isLoadingSuggestions: isLoadingSuggestions, isValid: isFilterQueryDraftValid, loadSuggestions: loadSuggestions, onChange: setFilterQueryDraftFromKueryExpression, onSubmit: applyFilterQueryFromKueryExpression, placeholder: intl.formatMessage({
                    id: 'xpack.infra.logsPage.toolbar.kqlSearchFieldPlaceholder',
                    defaultMessage: 'Search for log entries… (e.g. host.name:host-1)',
                }), suggestions: suggestions, value: filterQueryDraft ? filterQueryDraft.expression : '' })))))),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(source_configuration_1.SourceConfigurationButton, null)),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(log_customization_menu_1.LogCustomizationMenu, null,
                react_2.default.createElement(with_log_minimap_1.WithLogMinimap, null, ({ availableIntervalSizes, intervalSize, setIntervalSize }) => (react_2.default.createElement(log_minimap_scale_controls_1.LogMinimapScaleControls, { availableIntervalSizes: availableIntervalSizes, setIntervalSize: setIntervalSize, intervalSize: intervalSize }))),
                react_2.default.createElement(with_log_textview_1.WithLogTextview, null, ({ availableTextScales, textScale, setTextScale, setTextWrap, wrap }) => (react_2.default.createElement(react_2.default.Fragment, null,
                    react_2.default.createElement(log_text_wrap_controls_1.LogTextWrapControls, { wrap: wrap, setTextWrap: setTextWrap }),
                    react_2.default.createElement(log_text_scale_controls_1.LogTextScaleControls, { availableTextScales: availableTextScales, textScale: textScale, setTextScale: setTextScale })))))),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(with_log_position_1.WithLogPosition, { resetOnUnmount: true }, ({ visibleMidpointTime, isAutoReloading, jumpToTargetPositionTime, startLiveStreaming, stopLiveStreaming, }) => (react_2.default.createElement(log_time_controls_1.LogTimeControls, { currentTime: visibleMidpointTime, isLiveStreaming: isAutoReloading, jumpToTime: jumpToTargetPositionTime, startLiveStreaming: startLiveStreaming, stopLiveStreaming: stopLiveStreaming }))))))))));
