"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const graphql_tag_1 = tslib_1.__importDefault(require("graphql-tag"));
exports.sourceFieldsFragment = graphql_tag_1.default `
  fragment SourceFields on InfraSource {
    id
    version
    updatedAt
    configuration {
      name
      description
      metricAlias
      logAlias
      fields {
        container
        host
        message
        pod
        tiebreaker
        timestamp
      }
    }
    status {
      indexFields {
        name
        type
        searchable
        aggregatable
      }
      logIndicesExist
      metricIndicesExist
    }
  }
`;
