"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const react_redux_1 = require("react-redux");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
exports.withSummary = react_redux_1.connect((state) => ({
    buckets: store_1.logSummarySelectors.selectSummaryBuckets(state),
}), typed_redux_1.bindPlainActionCreators({
    load: store_1.logSummaryActions.loadSummary,
}));
exports.WithSummary = typed_react_1.asChildFunctionRenderer(exports.withSummary);
