"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
const availableTextScales = ['large', 'medium', 'small'];
exports.withLogTextview = react_redux_1.connect((state) => ({
    availableTextScales,
    textScale: store_1.logTextviewSelectors.selectTextviewScale(state),
    urlState: selectTextviewUrlState(state),
    wrap: store_1.logTextviewSelectors.selectTextviewWrap(state),
}), typed_redux_1.bindPlainActionCreators({
    setTextScale: store_1.logTextviewActions.setTextviewScale,
    setTextWrap: store_1.logTextviewActions.setTextviewWrap,
}));
exports.WithLogTextview = typed_react_1.asChildFunctionRenderer(exports.withLogTextview);
exports.WithLogTextviewUrlState = () => (react_1.default.createElement(exports.WithLogTextview, null, ({ urlState, setTextScale, setTextWrap }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: urlState, urlStateKey: "logTextview", mapToUrlState: mapToUrlState, onChange: newUrlState => {
        if (newUrlState && newUrlState.textScale) {
            setTextScale(newUrlState.textScale);
        }
        if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
            setTextWrap(newUrlState.wrap);
        }
    }, onInitialize: newUrlState => {
        if (newUrlState && newUrlState.textScale) {
            setTextScale(newUrlState.textScale);
        }
        if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
            setTextWrap(newUrlState.wrap);
        }
    } }))));
const mapToUrlState = (value) => value
    ? {
        textScale: mapToTextScaleUrlState(value.textScale),
        wrap: mapToWrapUrlState(value.wrap),
    }
    : undefined;
const mapToTextScaleUrlState = (value) => availableTextScales.includes(value) ? value : undefined;
const mapToWrapUrlState = (value) => (typeof value === 'boolean' ? value : undefined);
const selectTextviewUrlState = reselect_1.createSelector(store_1.logTextviewSelectors.selectTextviewScale, store_1.logTextviewSelectors.selectTextviewWrap, (textScale, wrap) => ({
    textScale,
    wrap,
}));
