"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const types_1 = require("../../graphql/types");
class WaffleNodeTypeSwitcher extends react_2.default.PureComponent {
    constructor() {
        super(...arguments);
        this.handleClick = (nodeType) => () => {
            this.props.changeNodeType(nodeType);
            this.props.changeGroupBy([]);
            this.props.changeMetric({ type: types_1.InfraMetricType.cpu });
        };
    }
    render() {
        return (react_2.default.createElement(eui_1.EuiKeyPadMenu, null,
            react_2.default.createElement(eui_1.EuiKeyPadMenuItem, { label: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.waffle.nodeTypeSwitcher.hostsLabel", defaultMessage: "Hosts" }), onClick: this.handleClick(types_1.InfraNodeType.host) },
                react_2.default.createElement("img", { src: "../plugins/infra/images/hosts.svg", role: "presentation", alt: "", className: "euiIcon euiIcon--large" })),
            react_2.default.createElement(eui_1.EuiKeyPadMenuItem, { label: "Kubernetes", onClick: this.handleClick(types_1.InfraNodeType.pod) },
                react_2.default.createElement("img", { src: "../plugins/infra/images/k8.svg", role: "presentation", alt: "", className: "euiIcon euiIcon--large" })),
            react_2.default.createElement(eui_1.EuiKeyPadMenuItem, { label: "Docker", onClick: this.handleClick(types_1.InfraNodeType.container) },
                react_2.default.createElement("img", { src: "../plugins/infra/images/docker.svg", role: "presentation", alt: "", className: "euiIcon euiIcon--large" }))));
    }
}
exports.WaffleNodeTypeSwitcher = WaffleNodeTypeSwitcher;
