"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const types_1 = require("../../graphql/types");
const link_to_1 = require("../../pages/link_to");
exports.NodeContextMenu = react_1.injectI18n(({ options, timeRange, children, node, isPopoverOpen, closePopover, nodeType, intl }) => {
    // Due to the changing nature of the fields between APM and this UI,
    // We need to have some exceptions until 7.0 & ECS is finalized. Reference
    // #26620 for the details for these fields.
    // TODO: This is tech debt, remove it after 7.0 & ECS migration.
    const APM_FIELDS = {
        [types_1.InfraNodeType.host]: 'context.system.hostname',
        [types_1.InfraNodeType.container]: 'container.id',
        [types_1.InfraNodeType.pod]: 'kubernetes.pod.uid',
    };
    const nodeLogsUrl = node.id
        ? link_to_1.getNodeLogsUrl({
            nodeType,
            nodeId: node.id,
            time: timeRange.to,
        })
        : undefined;
    const nodeDetailUrl = node.id
        ? link_to_1.getNodeDetailUrl({
            nodeType,
            nodeId: node.id,
            from: timeRange.from,
            to: timeRange.to,
        })
        : undefined;
    const apmTracesUrl = {
        name: intl.formatMessage({
            id: 'xpack.infra.nodeContextMenu.viewAPMTraces',
            defaultMessage: 'View {nodeType} APM traces',
        }, { nodeType }),
        href: `../app/apm#/traces?_g=()&kuery=${APM_FIELDS[nodeType]}~20~3A~20~22${node.id}~22`,
    };
    const panels = [
        {
            id: 0,
            title: '',
            items: [
                ...(nodeLogsUrl
                    ? [
                        {
                            name: intl.formatMessage({
                                id: 'xpack.infra.nodeContextMenu.viewLogsName',
                                defaultMessage: 'View logs',
                            }),
                            href: nodeLogsUrl,
                        },
                    ]
                    : []),
                ...(nodeDetailUrl
                    ? [
                        {
                            name: intl.formatMessage({
                                id: 'xpack.infra.nodeContextMenu.viewMetricsName',
                                defaultMessage: 'View metrics',
                            }),
                            href: nodeDetailUrl,
                        },
                    ]
                    : []),
                ...[apmTracesUrl],
            ],
        },
    ];
    return (react_2.default.createElement(eui_1.EuiPopover, { closePopover: closePopover, id: `${node.pathId}-popover`, isOpen: isPopoverOpen, button: children, panelPaddingSize: "none" },
        react_2.default.createElement(eui_1.EuiContextMenu, { initialPanelId: 0, panels: panels })));
});
