"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const gradient_legend_1 = require("./gradient_legend");
const type_guards_1 = require("./lib/type_guards");
const steps_legend_1 = require("./steps_legend");
exports.Legend = ({ legend, bounds, formatter }) => {
    return (react_1.default.createElement(LegendContainer, null,
        type_guards_1.isInfraWaffleMapGradientLegend(legend) && (react_1.default.createElement(gradient_legend_1.GradientLegend, { formatter: formatter, legend: legend, bounds: bounds })),
        type_guards_1.isInfraWaffleMapStepLegend(legend) && react_1.default.createElement(steps_legend_1.StepLegend, { formatter: formatter, legend: legend })));
};
const LegendContainer = styled_components_1.default.div `
  position: absolute;
  bottom: 10px;
  left: 10px;
  right: 10px;
`;
