"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importDefault(require("react"));
const react_2 = require("@kbn/i18n/react");
const with_source_1 = require("../../containers/with_source");
const fields_configuration_panel_1 = require("./fields_configuration_panel");
const indices_configuration_panel_1 = require("./indices_configuration_panel");
const name_configuration_panel_1 = require("./name_configuration_panel");
const source_configuration_flyout_state_1 = require("./source_configuration_flyout_state");
const source_configuration_form_state_1 = require("./source_configuration_form_state");
const noop = () => undefined;
exports.SourceConfigurationFlyout = react_2.injectI18n(({ intl }) => (react_1.default.createElement(source_configuration_flyout_state_1.WithSourceConfigurationFlyoutState, null, ({ disable: close, value: isVisible }) => isVisible ? (react_1.default.createElement(with_source_1.WithSource, null, ({ create, configuration, exists, isLoading, update }) => configuration ? (react_1.default.createElement(source_configuration_form_state_1.WithSourceConfigurationFormState, { initialFormState: {
        name: configuration.name,
        description: configuration.description,
        fields: {
            container: configuration.fields.container,
            host: configuration.fields.host,
            message: configuration.fields.message,
            pod: configuration.fields.pod,
            tiebreaker: configuration.fields.tiebreaker,
            timestamp: configuration.fields.timestamp,
        },
        logAlias: configuration.logAlias,
        metricAlias: configuration.metricAlias,
    } }, ({ getCurrentFormState, getNameFieldProps, getLogAliasFieldProps, getMetricAliasFieldProps, getFieldFieldProps, isFormValid, resetForm, updates, }) => (react_1.default.createElement(eui_1.EuiFlyout, { "aria-labelledby": "sourceConfigurationTitle", hideCloseButton: true, onClose: noop },
    react_1.default.createElement(eui_1.EuiFlyoutHeader, null,
        react_1.default.createElement(eui_1.EuiTitle, null,
            react_1.default.createElement("h2", { id: "sourceConfigurationTitle" },
                react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.sourceConfigurationTitle", defaultMessage: "Configure source" })))),
    react_1.default.createElement(eui_1.EuiFlyoutBody, null,
        react_1.default.createElement(name_configuration_panel_1.NameConfigurationPanel, { isLoading: isLoading, nameFieldProps: getNameFieldProps() }),
        react_1.default.createElement(eui_1.EuiSpacer, null),
        react_1.default.createElement(indices_configuration_panel_1.IndicesConfigurationPanel, { isLoading: isLoading, logAliasFieldProps: getLogAliasFieldProps(), metricAliasFieldProps: getMetricAliasFieldProps() }),
        react_1.default.createElement(eui_1.EuiSpacer, null),
        react_1.default.createElement(fields_configuration_panel_1.FieldsConfigurationPanel, { containerFieldProps: getFieldFieldProps('container'), hostFieldProps: getFieldFieldProps('host'), isLoading: isLoading, podFieldProps: getFieldFieldProps('pod'), tiebreakerFieldProps: getFieldFieldProps('tiebreaker'), timestampFieldProps: getFieldFieldProps('timestamp') })),
    react_1.default.createElement(eui_1.EuiFlyoutFooter, null,
        react_1.default.createElement(eui_1.EuiFlexGroup, null,
            react_1.default.createElement(eui_1.EuiFlexItem, { grow: false }, updates.length === 0 ? (react_1.default.createElement(eui_1.EuiButtonEmpty, { iconType: "cross", isDisabled: isLoading, onClick: () => close() },
                react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.closeButtonLabel", defaultMessage: "Close" }))) : (react_1.default.createElement(eui_1.EuiButtonEmpty, { color: "danger", iconType: "cross", isDisabled: isLoading, onClick: () => {
                    resetForm();
                    close();
                } },
                react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.discardAndCloseButtonLabel", defaultMessage: "Discard and Close" })))),
            react_1.default.createElement(eui_1.EuiFlexItem, null),
            react_1.default.createElement(eui_1.EuiFlexItem, { grow: false }, isLoading ? (react_1.default.createElement(eui_1.EuiButton, { color: "primary", isLoading: true, fill: true }, "Loading")) : (react_1.default.createElement(eui_1.EuiButton, { color: "primary", isDisabled: updates.length === 0 || !isFormValid(), fill: true, onClick: () => (exists ? update(updates) : create(getCurrentFormState())).then(() => resetForm()) },
                react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.updateSourceConfigurationButtonLabel", defaultMessage: "Update Source" })))))))))) : null)) : null)));
