"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importDefault(require("react"));
const react_2 = require("@kbn/i18n/react");
exports.IndicesConfigurationPanel = ({ isLoading, logAliasFieldProps, metricAliasFieldProps, }) => (react_1.default.createElement(eui_1.EuiForm, null,
    react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
        react_1.default.createElement("h3", null,
            react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.indicesSectionTitle", defaultMessage: "Indices" }))),
    react_1.default.createElement(eui_1.EuiSpacer, { size: "m" }),
    react_1.default.createElement(eui_1.EuiFormRow, { error: metricAliasFieldProps.error, fullWidth: true, helpText: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.metricIndicesDescription", defaultMessage: "Index pattern for matching indices that contain Metricbeat data. The recommended value is {defaultValue}.", values: {
                defaultValue: react_1.default.createElement(eui_1.EuiCode, null, "metricbeat-*"),
            } }), isInvalid: metricAliasFieldProps.isInvalid, label: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.metricIndicesLabel", defaultMessage: "Metric indices" }) },
        react_1.default.createElement(eui_1.EuiFieldText, Object.assign({ fullWidth: true, disabled: isLoading, isLoading: isLoading }, metricAliasFieldProps))),
    react_1.default.createElement(eui_1.EuiFormRow, { error: logAliasFieldProps.error, fullWidth: true, helpText: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.logIndicesDescription", defaultMessage: "Index pattern for matching indices that contain log data. The recommended value is {defaultValue}.", values: {
                defaultValue: react_1.default.createElement(eui_1.EuiCode, null, "filebeat-*"),
            } }), isInvalid: logAliasFieldProps.isInvalid, label: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.logIndicesLabel", defaultMessage: "Log indices" }) },
        react_1.default.createElement(eui_1.EuiFieldText, Object.assign({ fullWidth: true, disabled: isLoading, isLoading: isLoading }, logAliasFieldProps)))));
